% Road_PSD
%-------------------------------------------------------------------------
% Witten By Tomas Mauder, VUT v Brne, 2014.
%-------------------------------------------------------------------------

function [A_x omega_x phi_x psi_x] = Road_PSD_2D(road,graphs)

% Koeficient drsnosti pro referencni vlnove cislo (wave number) 1 rad/m
phi0_x = road.type_x;
% interval vlnoveho cisla pro PSD
omega0_x = road.omega0_x;
omega1_x = road.omega1_x;
omega2_x = road.omega2_x;
omega_cut = road.omega_cut;

% pocet vln pro PSD
M_x = road.M_x;
% velikost kroku pro PSD
delta_omega_x = (omega2_x-omega1_x)/(M_x - 2);
% Rozsah vlnovych cisel
omega_x = linspace(omega1_x,omega2_x,M_x);

% Inicializace PSD
phi_x = zeros(1,M_x);

% Inicializace amplitud
A_x = zeros(1,M_x);


% Koeficient zvlneni (waviness);
% Dlouhe vlny
wL_x = road.wL_x;

% Kratke vlny
wS_x = road.wS_x;

% Vypocet PSD (eq. 2.16)
for i = 1:M_x  
        if omega_x(i) <= omega0_x
            phi_x(i) = phi0_x * (omega_x(i)./omega0_x).^(-wL_x);
        else
            phi_x(i) = phi0_x * (omega_x(i)./omega0_x).^(-wS_x);
        end              
end

for i = 1:M_x
        if omega_x(i) <= omega_cut
             phi_x(i) = phi0_x * (omega_x(find(omega_x > omega_cut, 1 ))./omega0_x).^(-wL_x);
        end
end

% Vypocet amplitud (eq. 2.23)
A_x(1:M_x)= sqrt(2 * phi_x(1:M_x) * (delta_omega_x));

% Delka cesty (m)
L1_x = road.L1_x;
L2_x = road.L2_x;
L_x = L2_x - L1_x;

L1_y = road.L1_y;
L2_y = road.L2_y;
L_y = L2_y - L1_y;

% Pocet vzorku na 1 m cesty
N_x = road.N_x;
N_y = road.N_y;
% Rozdeleni cesty na L * N intervalu
s_x = L1_x:1/N_x:(L2_x);
s_y = L1_y:1/N_y:(L2_y);

% Vygenerovani nahodnych uhlu

psi_x(:,1)=random('unif',0,2*pi,M_x,1);
for i = 2: N_y * L_y + 1

    psi_x(:,i) = exp(-2*pi*s_y(i).*(omega_x/2/pi).^(1.5)) / (sqrt(1 - exp(-2*pi*s_y(i).*(omega_x/2/pi).^(1.5))) + exp(-2*pi*s_y(i).*(omega_x/2/pi).^(1.5))).*psi_x(:,1) ... 
          + sqrt(1 - exp(-2*pi*s_y(i).*(omega_x/2/pi).^(1.5))) / (sqrt(1 - exp(-2*pi*s_y(i).*(omega_x/2/pi).^(1.5))) + exp(-2*pi*s_y(i).*(omega_x/2/pi).^(1.5))).*random('unif',0,2*pi,M_x,1);   
end  
    

%-------------------------------------------------------------------------
% graficky vystup
if graphs == 1
phiAx(1:M_x) = 1 * 10^-6   * (omega_x(1:M_x)./omega0_x).^(-2);
phiBx(1:M_x) = 4 * 10^-6   * (omega_x(1:M_x)./omega0_x).^(-2);
phiCx(1:M_x) = 16 * 10^-6  * (omega_x(1:M_x)./omega0_x).^(-2);
phiDx(1:M_x) = 64 * 10^-6  * (omega_x(1:M_x)./omega0_x).^(-2);
phiEx(1:M_x) = 256 * 10^-6 * (omega_x(1:M_x)./omega0_x).^(-2);

figure(1)
% x - vlnove cislo [rad/m], y - PSD [m^2/(rad/m)]
loglog(omega_x,phi_x,'-b','linewidth',2); hold on
loglog(omega_x,phiAx,'-r');
loglog(omega_x,phiBx,'-g');
loglog(omega_x,phiCx,'-y');
loglog(omega_x,phiDx,'-c');
loglog(omega_x,phiEx,'-k'); hold off

title('PSD profil v ose x');
xlabel('Vlnove cislo [rad/m]');
ylabel('PSD [m^2/(rad/m)]');
set(gcf,'Color','w');
legend('PSD','PSD_A','PSD_B','PSD_C','PSD_D','PSD_E')


end

